function ExpandReplyForm(button) {
  var body = FindParentOf(button, 'div', 'body');
  var form = FindChildByPath(body, ['reply'], ['form', null]);
  var area = FindChildByPath(form, 'message', ['textarea', null]);

  if (DebugAssert(area)) {
    if ($style(form, 'display') == 'none') {
      $show(form);
      area.focus();
    } else {
      $hide(form);
    }
  }
}

function InitCommentFormOf(id) {
  if (id) {
    id = FindChildByPath(id, ['form', null], 'message');
  } else {
    id = 'messageInput';
  }

  var area = FindChildOf(id, 'textarea', null);

  if (!DebugAssert(area)) { return; }

  var form = FindParentOf(area, 'form', '');
  var button = FindChildByPath(form, 'submit', ['input', null]);

    if (DebugAssert(button)) {
      button.disabled = false;  // FF saves input fields' status and text over reloads.
    }

  area.onkeypress = area.onkeyup = function (e) {
    var lines = 0;
    // it seems impossible to get real width of characters inside a text area so using font-size.
    var cols = Math.round(WidthOf(this) / parseFloat( $style(this, 'font-size')) );

      $each(this.value.split("\n"), function (line) {
        lines += 1 + Math.floor(line.length / cols);
      });

    if (isNaN(this.OrigRows)) { this.OrigRows = this.rows; }
    this.rows = Math.max(Math.min(20, lines), this.OrigRows);

    if (e = window.event || e) {
      var key = e.which ? e.which : e.keyCode;
          key = e.keyCode == 10 ? 13 : e.keyCode;
      var ctrl = e.ctrlKey || e.modifiers == 2;

      if ( (key == 13 && ctrl) || (key == 0 && e.charCode == 106 && ctrl) ) {
        if (!button.disabled) {
          if (DebugAssert(form) && ( !IsFunc(form.onsubmit) || form.onsubmit() )) {
            form.submit();
          }

          CancelPropagationOf(e);   // e.g. Spellckecker hooks document's Ctrl+Enter.
          DisableSubmissionButton(button, 5000);
        }
      }
    }
  }

  area.onkeypress();
}
